#! /bin/bash

declare -a gpu_list=(0 1 0)
declare -a cpu_list=("0-7" "8-15" "16-23")

config_root=../config/cora/SDMP

root_result_path=../result/cora_SAGE_SDMP
GNN_target_path=../result/cora/SAGE

host_name=`uname -n`

# declare -a config_name=("cora_SDMP_SAGE_full_5theta.yml" "cora_SDMP_SAGE_full_20theta.yml" "cora_SDMP_SAGE_full_100theta.yml")

# for ((idx=0; idx<${#config_name[@]}; ++idx)); do
#     data_time=`date +"%Y-%m-%d %T" | sed -r 's/ /_/g'`
#     cur_result_path=${host_name}_${data_time}
#     taskset -c ${cpu_list[$idx]} python ../main_gen_SDMP.py --data ../dataset --config ${config_root}/${config_name[$idx]} --device "cuda:${gpu_list[$idx]}" --result "${root_result_path}/${cur_result_path}" --gnn $GNN_target_path > /dev/null &
#     pids[$idx]=$!
#     sleep 1
# done # end of for over train confi
# echo "Done this round of start!"
# for pid in ${pids[*]}; do
#     wait $pid
# done

declare -a config_name=("cora_SDMP_SAGE_theta_dense_k1_1_h_dense_1.yml" "cora_SDMP_SAGE_theta_dense_k1_2_h_dense_2.yml" "cora_SDMP_SAGE_theta_dense_k1_3_h_dense_3.yml")

for ((idx=0; idx<${#config_name[@]}; ++idx)); do
    data_time=`date +"%Y-%m-%d %T" | sed -r 's/ /_/g'`
    cur_result_path=${host_name}_${data_time}
    taskset -c ${cpu_list[$idx]} python ../main_gen_SDMP.py --data ../dataset --config ${config_root}/${config_name[$idx]} --device "cuda:${gpu_list[$idx]}" --result "${root_result_path}/${cur_result_path}" --gnn $GNN_target_path > /dev/null &
    pids[$idx]=$!
    sleep 1
done # end of for over train confi
echo "Done this round of start!"
for pid in ${pids[*]}; do
    wait $pid
done

declare -a config_name=("cora_SDMP_SAGE_theta_mixed_k1_1_k2_3_h_sparse_3.yml")

for ((idx=0; idx<${#config_name[@]}; ++idx)); do
    data_time=`date +"%Y-%m-%d %T" | sed -r 's/ /_/g'`
    cur_result_path=${host_name}_${data_time}
    taskset -c ${cpu_list[$idx]} python ../main_gen_SDMP.py --data ../dataset --config ${config_root}/${config_name[$idx]} --device "cuda:${gpu_list[$idx]}" --result "${root_result_path}/${cur_result_path}" --gnn $GNN_target_path > /dev/null &
    pids[$idx]=$!
    sleep 1
done # end of for over train confi
echo "Done this round of start!"
for pid in ${pids[*]}; do
    wait $pid
done
